# PDFC-Samples

This project provides code samples for the API usage of the [i-net PDF Content Comparer](https://www.inetsoftware.de/products/pdf-content-comparer "i-net PDF Content Comparer"). 
The samples are all written in Java and contain numerous examples for 

* Basic comparison procedure calls
* Analysis of the comparison results
* Customization of the comparison parameters by use of configuration settings
* Use of filters to control the comparison input  
* Generation of comparison reports with different format and layout
* Usage of the PDF Parser to inspect PDF documents 

To run the example projects, you need to have a Java Runtime Version installed. 

# Installation - Setting up the dependencies

Download the latest PDFC SDK at https://download.inetsoftware.de/pdfc-sdk-latest.zip and unzip the archive to a local directory. After that
 
1. Unpack the `*.jar` files from following plugins into the `lib` folder of the project and add these jar-files to the classpath.
    1. `i-net PDFC/plugins/pdfc.zip`
    2. `i-net PDFC/plugins/parser.pdf.zip`
    3. `i-net PDFC/plugins/reporting.zip`
2. copy `i-net PDFC/java/inetcore.jar` into the `lib` folder of the project and add this jar-file to the classpath.
3. copy the directory `i-net PDFC/i-net PDFC/lang` into the project folder (only for tesseract (OCR) usage)
4. copy at least the plugin files `i-net PDFC/plugins/parser.*.zip` (except `parser.pdf.zip`) and `plugins/filter.*.zip` into the
`plugins`-folder of the project, for OCR the files `i-net PDFC/plugins/ocr.*.zip` are needed as well 

After that, you are able to compile the project and run the sample programs.

## Activating i-net PDFC

In order to activate i-net PDFC, please check the `compare` scripts in the the `i-net PDFC` root directory and run it using the `-activate` parameter.

## Using the i-net PDFC programming API in an application server

For an application server, the same dependencies apply as for Java-API usage. But there are some additional points to consider:

* The `lib` folder has to be located in the `WEB-INF` of the web application or `.war`-file, while the `plugins` folder has to be located in the root.
* To enable i-net PDFC to resolve the plugins in the web application add the following line to the `init()` mehtod of the Servlet of the web application: `ServletUtils.setServletContext( config.getServletContext() );` with `config` beeing the `ServletConfig` passed to the `init()` mehtod.
